/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer;

import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.EntityBackedTrainerBattleActor;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.PlayerBackedTrainerBattleActor;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.SafeCopyBattlePokemonFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.TrainerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MessagePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.preset.RentalBattlePreset;
import kiwiapollo.cobblemontrainerbattle.common.LevelMode;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerStorage;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class RentalBattleTrainer
implements TrainerBattleParticipant {
    private final TrainerBattleParticipant trainer;

    public RentalBattleTrainer(String trainer) {
        this.trainer = TrainerStorage.getInstance().get(trainer);
    }

    @Override
    public List<MessagePredicate<PlayerBattleParticipant>> getPredicates() {
        return this.trainer.getPredicates();
    }

    @Override
    public AIBattleActor createBattleActor(class_3222 player) {
        try {
            return new EntityBackedTrainerBattleActor(this.getName(), this.getUuid(), this.getBattleTeam(player), this.getBattleAI(), this.getNearAttachedLivingEntity(player));
        }
        catch (ClassCastException | NullPointerException e) {
            return new PlayerBackedTrainerBattleActor(this.getName(), this.getUuid(), this.getBattleTeam(player), this.getBattleAI(), player);
        }
    }

    @Override
    public class_1309 getNearAttachedLivingEntity(class_3222 player) {
        return this.trainer.getNearAttachedLivingEntity(player);
    }

    @Override
    public List<BattlePokemon> getBattleTeam(class_3222 player) {
        List<Object> team = new ArrayList<BattlePokemon>(this.getParty().toGappyList().stream().filter(Objects::nonNull).map(new SafeCopyBattlePokemonFactory()).toList());
        Collections.shuffle(team);
        team = team.subList(0, RentalBattlePreset.PARTY_SIZE);
        team.forEach(pokemon -> pokemon.getEffectedPokemon().setLevel(RentalBattlePreset.LEVEL));
        team.forEach(pokemon -> pokemon.getEffectedPokemon().heal());
        return team;
    }

    @Override
    public void onPlayerDefeat(class_3222 player) {
        this.trainer.onPlayerDefeat(player);
    }

    @Override
    public void onPlayerVictory(class_3222 player) {
        this.trainer.onPlayerVictory(player);
        BattleContextStorage.getInstance().getOrCreate(player.method_5667()).setTradablePokemon(this.toClone(this.getParty()));
    }

    @Override
    public class_2960 getTexture() {
        return this.trainer.getTexture();
    }

    private PartyStore toClone(PartyStore party) {
        PartyStore clone = new PartyStore(UUID.randomUUID());
        party.forEach(pokemon -> clone.add(pokemon.clone(true, null)));
        return clone;
    }

    @Override
    public String getId() {
        return this.trainer.getId();
    }

    @Override
    public BattleAI getBattleAI() {
        return this.trainer.getBattleAI();
    }

    @Override
    public BattleFormat getBattleFormat() {
        return this.trainer.getBattleFormat();
    }

    @Override
    public Optional<class_3414> getBattleTheme() {
        return this.trainer.getBattleTheme();
    }

    @Override
    public LevelMode getLevelMode() {
        return LevelMode.FLAT;
    }

    @Override
    public boolean isSpawningAllowed() {
        return this.trainer.isSpawningAllowed();
    }

    @Override
    public String getName() {
        return this.trainer.getName();
    }

    @Override
    public UUID getUuid() {
        return this.trainer.getUuid();
    }

    @Override
    public PartyStore getParty() {
        return this.trainer.getParty();
    }
}

